#include <p30fxxxx.h>
#include <spi.h>

/********************************************************************************
*   Function Name :  OpenSPI2                                                   *
*   Description   :  This function Initializes the SPI module and Also enables  *
                     SPI module 
*   Parameters    :  unsigned int config1,unsigned int config2                  *
*   Return Value  :  None                                                       *
*   Note:            Config1 contains information about framed SPI support,     *
                     frame sync pulse,Disable SDO pin, Word/byte communication  *  
                     data input sample phase bit, clock edge select bit,slave   *
*                    select ,clock polarity select bit ,Master enable bit       *
*                    secondary prescale bit, Primary prescale bit               *
*                    Config2 contains information about Enable/Disable SPI,SPI  *
                     Operation during CPU IDLE mode                             *
*********************************************************************************/

/* The following devices support SPI2 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__)  || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) ||  defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)   

void OpenSPI2(unsigned int config1,unsigned int config2)
{   
     SPI2CON = config1;   /* Initalizes the spi module */ 
     SPI2STAT = config2;  /* Enable/Disable the spi module */ 
}

#endif
